﻿DROP PROCEDURE [hips].[DisclosureAuditInsert]
GO

/****** Object:  StoredProcedure [hips].[DisclosureAuditInsert]    Script Date: 12/18/2012 15:45:29 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Create date: 18 Dec 2012
-- Description:   Inserts a new record into the Disclosure Audit Table
-- =============================================
CREATE PROCEDURE [hips].[DisclosureAuditInsert] 
(
	  @HealthProviderOrganisationId INT
	, @PatientMasterId INT
	, @PcehrDisclosed BIT
	, @AuditInformation VARBINARY(MAX) = NULL
	, @UserModified varchar(256)
) 
AS
BEGIN
    SET NOCOUNT ON

    DECLARE @intErrorCode int
          , @DisclosureAuditId int

    SET @intErrorCode = 0


	INSERT INTO hips.DisclosureAudit
	(
		[HealthProviderOrganisationId],
		[PatientMasterId],
		[PcehrDisclosed],
		[AuditInformation],
		[DateCreated],
        [UserCreated],
        [DateModified],
        [UserModified]
		)
VALUES
	(
	  @HealthProviderOrganisationId
	, @PatientMasterId
	, @PcehrDisclosed
	, @AuditInformation
	, GETDATE()
    , @UserModified
    , GETDATE()
    , @UserModified
	)
	
	 SELECT @intErrorCode = @@ERROR , @DisclosureAuditId = SCOPE_IDENTITY()
    IF @intErrorCode = 0
    BEGIN
        SELECT [DisclosureAuditId],
                HealthProviderOrganisationId,
                PatientMasterId,
				PcehrDisclosed,
				AuditInformation,
                [DateCreated],
                [UserCreated],
                [DateModified],
                [UserModified]
         FROM [hips].[DisclosureAudit]
         WHERE [DisclosureAuditId] = @DisclosureAuditId
    END

    RETURN(@intErrorCode)

END
GO

